/*
 * wlt - Terminals
 *
 * Copyright (c) 2012 David Herrmann <dh.herrmann@googlemail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * Wayland Terminal console helpers
 */

#ifndef WLT_TERMINAL_H
#define WLT_TERMINAL_H

#include <stdlib.h>
#include "wlt_toolkit.h"

struct wlt_terminal;

enum wlt_terminal_event_type {
	WLT_TERMINAL_HUP,
};

typedef void (*wlt_terminal_cb) (struct wlt_terminal *term,
				 unsigned int event,
				 void *data);

int wlt_terminal_new(struct wlt_terminal **out, struct wlt_window *wnd);
void wlt_terminal_destroy(struct wlt_terminal *term);

int wlt_terminal_open(struct wlt_terminal *term, wlt_terminal_cb cb,
		      void *data);

#endif /* WLT_TERMINAL_H */
